/*
 * Decompiled with CFR 0.152.
 */
package Game_Engine.levelEditor;

import BryceGraphs.Algorithms.GraphSerial;
import BryceGraphs.gui_components.gui_GNode;
import BryceGraphs.gui_components.gui_TreeViewer;
import BryceGraphs.gui_components.nodes.gnode_file;
import Data_Structures.Structures.List;
import Game_Engine.Engine.Objs.Obj;
import Game_Engine.Engine.Objs.room_functional;
import Game_Engine.GUI.Components.small.gui_button;
import Game_Engine.levelEditor.room_editor;
import Game_Engine.levelEditor.rootSerial;
import java.io.File;
import java.io.PrintStream;
import java.util.Iterator;
import util.FileIO;
import util.deSerialB;
import util.interfaces.Consumer2;
import util.interfaces.Function;
import util.testing;

public abstract class room_GameTree
extends room_functional<File>
implements deSerialB {
    static int number = 0;
    private File myDir;
    private File myFile;
    private File mySaveDir;
    private File mySaveFile;
    private final int ROW_H = 64;
    private gui_button back_button;
    gui_TreeViewer tree = null;
    gnode_file root = null;

    public room_GameTree(File directory, File saveDir) {
        this.myDir = directory;
        this.myFile = new File(this.myDir, "LevelGraph." + this.getExtension());
        this.serializeFrom(this.myFile);
        this.mySaveDir = saveDir;
        this.mySaveFile = new File(this.mySaveDir, "SavedGame.sav");
    }

    @Override
    public void iObjs() {
        gui_TreeViewer W = new gui_TreeViewer(0.0, 64.0, this.getW(), this.getH() - 64);
        this.obj_create((Obj)W);
        this.tree = W;
        W.editNode(this.getRootFile(), 350, 256);
        W.propogateNodes();
        this.back_button = new gui_button(0.0, 0.0, this.getW(), 64);
        this.back_button.setText("Go Back to the Level Editor");
        this.obj_create((Obj)this.back_button);
    }

    @Override
    public void update() {
        super.update();
        if (this.back_button.flag()) {
            this.serializeGameTree(this.myFile);
            this.serializeSavedGame(this.mySaveFile);
            this.Return();
        }
    }

    @Override
    public String getExtension() {
        return "filegraph";
    }

    @Override
    public void serializeFrom(File input) {
        if (!input.exists()) {
            return;
        }
        List<String> data = FileIO.readFile(input);
        Iterator<String> iter2 = data.iterator();
        testing.ASSERT(iter2.next().equals(this.getSerialName()));
        this.root = GraphSerial.deserialize(iter2, new FileNodeFactory());
    }

    private gnode_file getRootFile() {
        if (this.root != null) {
            return this.root;
        }
        return new gnode_file(null, null, room_editor.chooser_room);
    }

    @Override
    public String getSerialName() {
        return "Game Tree File";
    }

    @rootSerial
    private void serializeGameTree(File output) {
        FileIO.createFile(output);
        PrintStream stream = FileIO.getStream(output);
        stream.println(this.getSerialName());
        this.tree.serializeTo(stream);
        FileIO.closeFile(output);
    }

    @rootSerial
    private void serializeSavedGame(File output) {
        FileIO.createFile(output);
        PrintStream stream = FileIO.getStream(output);
        stream.println("Saved Game file. Version 1");
        this.tree.serializeTo(stream, this.getSavedGameContinuation());
        FileIO.closeFile(output);
    }

    protected abstract Consumer2<gui_GNode, PrintStream> getSavedGameContinuation();

    private class FileNodeFactory
    implements Function<Iterator<String>, gnode_file> {
        private FileNodeFactory() {
        }

        @Override
        public gnode_file eval(Iterator<String> data_stream) {
            return gnode_file.deserialize(data_stream, room_editor.chooser_room);
        }
    }
}

